define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.service('InstitutionsService', function ($http, $q, localResourceDirectoryService, mhpuser) {
		var deferred = $q.defer();
		var service = {
			setActiveInstitution: function(institution){
				this.activeInstitution = institution;
			},
			getActiveInstitution: function(){
				return this.activeInstitution;
			}
		};

        var resourceDirectoryDeferred = localResourceDirectoryService.fetch();
        var mhpuserDeferred = mhpuser.fetch();

        $q.all([resourceDirectoryDeferred,mhpuserDeferred]).then(function(serviceResults){
            $http.get(serviceResults[0]['institutions'].replace('{site-code}', serviceResults[1].vistaLocation)).then(function(institutions){
                service.institutions = institutions;
                deferred.resolve(service);
            });
        });

		return deferred.promise;
	});
});